/******************************************************************************
 *
 *		 I 2 C   D R I V E R  H E A D E R - Mikado Level
 *
 */
#ifndef I2C_H
#define I2C_H
 
typedef unsigned char uchar;

// Hardware Pins
#define SDA_TRIS		TRISBbits.TRISB4
#define SCK_TRIS		TRISBbits.TRISB6

#define ERR_START		1
#define ERR_ADDR		2
#define ERR_REG			3
#define ERR_DATA		4
#define ERR_RESTART		5
#define ERR_OFLOW		6



void i2cInitialise(void);
uchar i2cWrite(uchar device, uchar add, uchar num, uchar *data);
uchar i2cRead(uchar device, uchar add, uchar num, uchar *data);
uchar i2cGetByte(uchar device, uchar address);
uchar i2cSetByte(uchar device, uchar address, uchar data);
void i2cStateMachine(void);

#endif